<?php

/**
 * The MIT License.
 *
 * Copyright (c) 2023 "YooMoney", NBСO LLC
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

namespace YooKassa\Model\Payment\PaymentMethod;

use YooKassa\Validator\Constraints as Assert;
use YooKassa\Model\Payment\PaymentMethodType;

/**
 * Класс, представляющий модель PaymentMethodAlfabank.
 *
 * Оплата через Альфа-Клик.
 *
 * @category Class
 * @package  YooKassa\Model
 * @author   cms@yoomoney.ru
 * @link     https://yookassa.ru/developers/api
 * @deprecated Будет удален в следующих версиях
 *
 * @property string $login Имя пользователя в Альфа-Клике
 */
class PaymentMethodAlfaBank extends AbstractPaymentMethod
{
    /**
     * Логин пользователя в Альфа-Клике (привязанный телефон или дополнительный логин).
     *
     * @var string|null
     */
    #[Assert\Type('string')]
    private ?string $_login = null;

    public function __construct(?array $data = [])
    {
        parent::__construct($data);
        $this->setType(PaymentMethodType::ALFABANK);
    }

    /**
     * Возвращает login.
     *
     * @return string|null
     */
    public function getLogin(): ?string
    {
        return $this->_login;
    }

    /**
     * Устанавливает login.
     *
     * @param string|null $login Логин пользователя в Альфа-Клике (привязанный телефон или дополнительный логин).
     *
     * @return self
     */
    public function setLogin(?string $login = null): self
    {
        $this->_login = $this->validatePropertyValue('_login', $login);
        return $this;
    }
}
